#ifndef XFLTK__GUI_H_
#define XFLTK__GUI_H_

#include <map>
#include <istream>
#include <fltk/widget.h>
#include <fltk/window.h>

#include <istream>
#include <expat.h>

#include "Error.h"

#include "utils.h"

namespace xfltk {

class GUI {
	
	friend void XMLCALL startElement(void *userData, const char *name, const char **atts);
	
	typedef std::map<const char*, fltk::Widget*, utils::ltstr> widget_map_type;
	
	widget_map_type widget_map;
	
	fltk::Widget* _root;
	
public:

	/**
	 * Last parsing errors.
	 * If empty last parsing was succesful.
	 */
	Errors errors;

	/**
	 * Construct empty GUI object.
	 */
	GUI(): _root(0) {};

	/**
	 * Construct GUI and read it from stream.
	 * @param in_stream
	 */
	GUI(std::istream& in_stream);
	
	/**
	 * Construct GUI and read it from file.
	 * @param file
	 */
	GUI(const char* file_name);
	
	/**
	 * Call clear();
	 */
	virtual ~GUI();
	
	/**
	 * @return widget with given id from map
	 */
	fltk::Widget* operator[](const char* name);
	
	/**
	 * Add widget to widgets map.
	 * @param id widget id in map
	 * @param w widget
	 */
	void setWidget(const char* id, fltk::Widget* w) {
		widget_map[id] = w;
	};
	
	/**
	 * @return root widget
	 */
	fltk::Widget* root() {
		return _root;
	}
	
	/**
	 * @return root as fltk::Window or 0 (if <code>root==0</code> or is not fltk::Window class)
	 */
	fltk::Window* rootAsWindow() {
		return dynamic_cast<fltk::Window*>(_root);
	}
		
	/**
	 * Read widget from stream.
	 * @param in_stream
	 * @param g
	 */
	friend std::istream& operator>>(std::istream& in_stream, GUI& g);
	
	/**
	 * Read widget from XML file.
	 * @param file_name file name
	 */
	void readFromFile(const char* file_name);
	
	/**
	 * Delete all widgets.
	 * Delete roor widget and clear widgets map.
	 */
	void clear();

};

} //namespace xfltk

#endif /*XFLTK__GUI_H_*/
