#include <fltk/run.h>
#include <fltk/Window.h>
#include <iostream>
#include <xfltk/GUI.h>

int main(int argc, char *argv[]) {
	if (argc < 2) {
		std::cout << "Usage: " << argv[0] << " file_name.xml";
		return 0;
	}
	
	xfltk::GUI g(argv[1]);
	
	if (!g.errors.empty()) {
		std::cerr << g.errors;
	}
	
	if (!g.root()) {
		std::cerr << "no root widget found" << std::endl;
		return 1;
	}
	
	fltk::Window* main_window = g.rootAsWindow();
	
	if (!main_window) {
		main_window = new fltk::Window(g.root()->x(), g.root()->y());
		main_window->add_resizable(*g.root());
	}
	
	main_window->show();
	return fltk::run();
}
