#ifndef XFLTK__CAST_H_
#define XFLTK__CAST_H_

#include <sstream>
#include <cstring>
#include <algorithm>

namespace xfltk {

namespace utils {

template <typename dst, typename src>
dst cast(const src& arg) {
	std::stringstream s;
	s << arg;
	dst result;
	s >> result;
	return result;
}

struct ltstr {
  bool operator()(const char* s1, const char* s2) const {
    return strcmp(s1, s2) < 0;
  }
};

struct eqstr {
	bool operator()(const char* s1, const char* s2) const {
		return strcmp(s1, s2) == 0;
	}
};

template <typename Iterator, typename Value>
Value find_pair(Iterator begin, Value to_find) {
	while (*begin != 0) {
		if (eqstr()(*begin, to_find))
			return *(++begin);
		begin += 2;
	}
	return 0;
}

char* strcopy(const char* src);

};	//namespace utils

};	//namespace xfltk

#endif /*XFLTK__CAST_H_*/
