#include "WidgetCreator.h"

#include <fltk/Widget.h>

#include <fltk/Button.h>
#include <fltk/CheckButton.h>
#include <fltk/LightButton.h>
#include <fltk/RadioLightButton.h>
#include <fltk/HighlightButton.h>
#include <fltk/RepeatButton.h>
#include <fltk/ReturnButton.h>
#include <fltk/ToggleButton.h>

#include <fltk/Clock.h>

#include <fltk/Divider.h>

#include <fltk/Input.h>
#include <fltk/NumericInput.h>
#include <fltk/FloatInput.h>
#include <fltk/IntInput.h>
#include <fltk/Output.h>
#include <fltk/MultiLineOutput.h>
#include <fltk/WordwrapOutput.h>

#include <fltk/InvisibleBox.h>

#include <fltk/Item.h>

#include <fltk/Valuator.h>
#include <fltk/Adjuster.h>
#include <fltk/Dial.h>
#include <fltk/FillDial.h>
#include <fltk/LineDial.h>
#include <fltk/Slider.h>
#include <fltk/FillSlider.h>
#include <fltk/Scrollbar.h>
#include <fltk/ValueSlider.h>
#include <fltk/ThumbWheel.h>
#include <fltk/ValueInput.h>
#include <fltk/ValueOutput.h>

#include <fltk/Group.h>
#include <fltk/Menu.h>
#include <fltk/Browser.h>
#include <fltk/MultiBrowser.h>
#include <fltk/Choice.h>
#include <fltk/CycleButton.h>
#include <fltk/ItemGroup.h>
#include <fltk/PopupMenu.h>
#include <fltk/MenuBar.h>
#include <fltk/PackedGroup.h>
#include <fltk/ScrollGroup.h>
#include <fltk/TabGroup.h>
#include <fltk/Window.h>
#include <fltk/ShapedWindow.h>

#include <fltk/Style.h>
#include <fltk/Symbol.h>
#include <fltk/LabelType.h>

#include <fltk/Font.h>
#include <fltk/LabelType.h>

#include "utils.h"

namespace xfltk {
	
//---=== WidgetFactory ===---
	
WidgetFactory::widget_factories_map WidgetFactory::widget_factories;

WidgetFactory::WidgetFactory(const char* name) {
	if (name)
		widget_factories[name] = this;
}

WidgetFactory* WidgetFactory::find(const char* name) {
	widget_factories_map::iterator res = widget_factories.find(name);
	return (res == widget_factories.end()) ? 0 : res->second;
}

WidgetCreator* WidgetFactory::getCreator(const char* name, GUI& gui) {
	WidgetFactory* f = find(name);
	return f ? f->getCreator(gui) : 0;
}

//---=== HierarhyWidgetCreator ===---

HierarhyWidgetFactory::HierarhyWidgetFactory(const char* name, HierarhyWidgetFactory* parent)
: WidgetFactory(name), parent(parent) {}

HierarhyWidgetFactory::widget_property_setters_map& HierarhyWidgetFactory::getWidgetPropertySetters() {
	/*if (!widget_property_setters) {
		widget_property_setters = new widget_property_setters_map();
		fill_property_setters();
	}*/
	return widget_property_setters;
}

void HierarhyWidgetFactory::setProperty(fltk::Widget* obj, const char* name, const char* value, WidgetCreator& creator) {
	widget_property_setters_map::iterator res = getWidgetPropertySetters().find(name);
	if (res != getWidgetPropertySetters().end())
		res->second(obj, value, creator);
	else
		if (parent)
			parent->setProperty(obj, name, value, creator);
		//TODO else rzu� wyj�tek: z�a nazwa w�a�ciwo�ci
}

void HierarhyWidgetFactory::setProperties(fltk::Widget* obj, const char** attr, WidgetCreator& creator) {
	for (; *attr; attr += 2)
		if (!utils::eqstr()(attr[0], "id"))
			setProperty(obj, attr[0], attr[1], creator);
}

void HierarhyWidgetFactory::addPropertySetter(const char* name, property_setter setter) {
	getWidgetPropertySetters()[name] = setter;
}

//---=== Standart widget factories ===---

/**
 * Call method from class type CLASS_TYPE which have one parameter type PARAMETER_TYPE.
 * Parse value as PARSE_PARAMETER_TYPE and cast it to PARAMETER_TYPE.
 */
template <typename CLASS_TYPE, typename PARSE_PARAMETER_TYPE, typename PARAMETER_TYPE, void (CLASS_TYPE::*method)(PARAMETER_TYPE)>
void cast_cast_caller(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	(((CLASS_TYPE*)obj)->*method)((PARAMETER_TYPE) utils::cast<PARSE_PARAMETER_TYPE>(value));
}

/**
 * Call method from class type CLASS_TYPE which have one parameter type PARAMETER_TYPE.
 */
template <typename CLASS_TYPE, typename PARAMETER_TYPE, void (CLASS_TYPE::*method)(PARAMETER_TYPE)>
void cast_caller(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	(((CLASS_TYPE*)obj)->*method)(utils::cast<PARAMETER_TYPE>(value));
}

/**
 * Call method from class type CLASS_TYPE which have one parameter type PARAMETER_TYPE.
 * Ignorse returned result.
 */
template <typename CLASS_TYPE, typename PARAMETER_TYPE, PARAMETER_TYPE (CLASS_TYPE::*method)(PARAMETER_TYPE)>
void cast_caller(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	(((CLASS_TYPE*)obj)->*method)(utils::cast<PARAMETER_TYPE>(value));
}

/**
 * Call method from class type CLASS_TYPE which have one parameter type const char*
 */
template <typename CLASS_TYPE, void (CLASS_TYPE::*method)(const char*)>
void string_caller(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	(((CLASS_TYPE*)obj)->*method)(value);
}

/**
 * Call method from class type CLASS_TYPE which have one parameter type fltk::Color.
 * Parse color from number or name (TODO).
 */
template <typename CLASS_TYPE, void (CLASS_TYPE::*method)(fltk::Color)>
void color_caller(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	(((CLASS_TYPE*)obj)->*method)(utils::cast<fltk::Color>(value));
}

/**
 * Call method from class type CLASS_TYPE which have no parameter.
 * If value represent bool true invokes method_true method else invokes method_false.
 */
template <typename CLASS_TYPE, void (CLASS_TYPE::*method_true)(void), void (CLASS_TYPE::*method_false)(void)>
void bool_caller(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	if (utils::cast<bool>(value))
		(((CLASS_TYPE*)obj)->*method_true)();
	else
		(((CLASS_TYPE*)obj)->*method_false)();
}

/**
 * Call method from class type CLASS_TYPE which have no parameter.
 * If value represent bool true invokes method_true method else invokes method_false.
 * Ignors returned value.
 */
template <typename CLASS_TYPE, bool (CLASS_TYPE::*method_true)(void), bool (CLASS_TYPE::*method_false)(void)>
void bool_caller(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	if (utils::cast<bool>(value))
		(((CLASS_TYPE*)obj)->*method_true)();
	else
		(((CLASS_TYPE*)obj)->*method_false)();
}

template <typename CLASS_TYPE, void (CLASS_TYPE::*method)(fltk::Font* v)>
void font_caller(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	fltk::Font* font = fltk::font(value);
	if (font)
		(((CLASS_TYPE*)obj)->*method)(font);
	//TODO else error
}

/*template <typename CLASS_TYPE, void (CLASS_TYPE::*method)(fltk::LabelType* v)>
void labeltype_caller(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	fltk::LabelType* label_type = fltk::LabelType::find(value);
	if (label_type)
		(((CLASS_TYPE*)obj)->*method)(label_type);
}*/

template <typename CLASS_TYPE, void (CLASS_TYPE::*method)(const fltk::Symbol* s)>
void symbol_caller(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	const fltk::Symbol* symbol = fltk::Symbol::find(value);
	if (symbol)
		(((CLASS_TYPE*)obj)->*method)(symbol);
	//TODO else error
}

//----------========== fltk::Widget ==========----------//

struct FactoryWidget: public HierarhyWidgetFactory {
	
	FactoryWidget();
	
	WidgetCreator* getCreator(GUI& gui) { return new HierarhyWidgetCreator<fltk::Widget>(gui, *this); };
	
};

static FactoryWidget factory_fltk_widget;

void set_style(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	obj->copy_style(fltk::Style::find(value));
}

/*void set_image(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	obj->image(fltk::Symbol::find(value));
}*/

void set_labeltype(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	obj->labeltype(fltk::LabelType::find(value));
	//TODO error if find return 0
}

FactoryWidget::FactoryWidget(): HierarhyWidgetFactory("widget", 0) {
	
	widget_property_setters_map& property = getWidgetPropertySetters();
	
	property["rectangle.x"] = property["x"] = cast_caller<fltk::Rectangle, int, &fltk::Rectangle::x>;
	property["rectangle.y"] = property["y"] = cast_caller<fltk::Rectangle, int, &fltk::Rectangle::y>;
	property["rectangle.w"] = property["w"] = cast_caller<fltk::Rectangle, int, &fltk::Rectangle::w>;
	property["rectangle.h"] = property["h"] = cast_caller<fltk::Rectangle, int, &fltk::Rectangle::h>;
	
	property["widget.activate"] = property["activate"] = bool_caller<fltk::Widget, &fltk::Widget::activate, &fltk::Widget::deactivate>;
	//TODO ? activate(int b)
	//TODO flags, align
	
	//TODO box, buttonbox, focusbox fix??
	/*property["widget.box"] = property["box"] = symbol_caller<fltk::Widget, &fltk::Widget::box>;
	property["widget.buttonbox"] = property["buttonbox"] = symbol_caller<fltk::Widget, &fltk::Widget::buttonbox>;
	property["widget.focusbox"] = property["focusbox"] = symbol_caller<fltk::Widget, &fltk::Widget::focusbox>;	*/
	
	property["widget.changed"] = property["changed"] = bool_caller<fltk::Widget, &fltk::Widget::set_changed, &fltk::Widget::clear_changed>;
	property["widget.click_to_focus"] = property["click_to_focus"] = bool_caller<fltk::Widget, &fltk::Widget::set_click_to_focus, &fltk::Widget::clear_click_to_focus>;
	property["widget.output"] = property["output"] = bool_caller<fltk::Widget, &fltk::Widget::set_output, &fltk::Widget::clear_output>;
	property["widget.selected"] = property["selected"] = bool_caller<fltk::Widget, &fltk::Widget::set_selected, &fltk::Widget::clear_selected>;
	property["widget.tab_to_focus"] = property["tab_to_focus"] = bool_caller<fltk::Widget, &fltk::Widget::set_tab_to_focus, &fltk::Widget::clear_tab_to_focus>;
	property["widget.value"] = property["value"] = bool_caller<fltk::Widget, &fltk::Widget::set_value, &fltk::Widget::clear_value>;
	property["widget.visible"] = property["visible"] = bool_caller<fltk::Widget, &fltk::Widget::set_visible, &fltk::Widget::clear_visible>;
	property["widget.style"] = property["style"] = set_style;
	property["widget.image"] = property["image"] = symbol_caller<fltk::Widget, &fltk::Widget::image>;
	property["widget.tooltip"] = property["tooltip"] = string_caller<fltk::Widget, &fltk::Widget::tooltip>;
	//TODO ? when
	//TODO ? take_focus
	//TODO cursor
	//TODO ? measure_label
	//TODO glyph
	property["widget.labelfont"] = property["labelfont"] = font_caller<fltk::Widget, &fltk::Widget::labelfont>;
	property["widget.textfont"] = property["textfont"] = font_caller<fltk::Widget, &fltk::Widget::textfont>;
	//TODO position 
	//TODO resize(w, h) resize(x, y, w, h) (-> size)
	property["widget.labeltype"] = property["labeltype"] = set_labeltype;
	property["widget.color"] = property["color"] = color_caller<fltk::Widget, &fltk::Widget::color>;
	property["widget.textcolor"] = property["textcolor"] = color_caller<fltk::Widget, &fltk::Widget::textcolor>;
	property["widget.selection_color"] = property["selection_color"] = color_caller<fltk::Widget, &fltk::Widget::selection_color>;
	property["widget.selection_textcolor"] = property["selection_textcolor"] = color_caller<fltk::Widget, &fltk::Widget::selection_textcolor>;
	property["widget.buttoncolor"] = property["buttoncolor"] = color_caller<fltk::Widget, &fltk::Widget::buttoncolor>;
	property["widget.labelcolor"] = property["labelcolor"] = color_caller<fltk::Widget, &fltk::Widget::labelcolor>;
	property["widget.highlight_color"] = property["highlight_color"] = color_caller<fltk::Widget, &fltk::Widget::highlight_color>;
	property["widget.highlight_textcolor"] = property["highlight_textcolor"] = color_caller<fltk::Widget, &fltk::Widget::highlight_textcolor>;
	property["widget.labelsize"] = property["labelsize"] = cast_caller<fltk::Widget, float, &fltk::Widget::labelsize>;
	property["widget.textsize"] = property["textsize"] = cast_caller<fltk::Widget, float, &fltk::Widget::textsize>;
	property["widget.leading"] = property["leading"] = cast_caller<fltk::Widget, float, &fltk::Widget::leading>;
	//TODO scrollbar_align
	property["widget.scrollbar_width"] = property["scrollbar_width"] = cast_cast_caller<fltk::Widget, unsigned, unsigned char, &fltk::Widget::scrollbar_width>;
	property["widget.vertical"] = property["vertical"] = bool_caller<fltk::Widget, &fltk::Widget::set_vertical, &fltk::Widget::set_horizontal>;
	property["widget.horizontal"] = property["horizontal"] = bool_caller<fltk::Widget, &fltk::Widget::set_horizontal, &fltk::Widget::set_vertical>;
	//TODO shortcut
	property["widget.label"] = property["label"] = string_caller<fltk::Widget, &fltk::Widget::copy_label>;
}

//----------========== fltk::Button ==========----------//

static struct FactoryButton: public HierarhyWidgetFactory {
	
	FactoryButton();
	
	WidgetCreator* getCreator(GUI& gui) { return new HierarhyWidgetCreator<fltk::Button>(gui, *this); };
	
} factory_fltk_button;


FactoryButton::FactoryButton(): HierarhyWidgetFactory("button", &factory_fltk_widget) {
	widget_property_setters_map& property = getWidgetPropertySetters();
	property["button.set"] = property["set"] = bool_caller<fltk::Button, &fltk::Button::set, &fltk::Button::clear>;
	property["button.value"] = property["value"] = cast_caller<fltk::Button, bool, &fltk::Button::value>;
}

// TODO ? fltk::BButton

//----------========== fltk::CheckButton ==========----------//

static struct CheckButtonFactory: public HierarhyWidgetFactory {
	
	CheckButtonFactory(): HierarhyWidgetFactory("checkButton", &factory_fltk_button) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::CheckButton>(gui, *this);
	}
	
} factory_fltk_checkButton;

//----------========== fltk::LightButton ==========----------//

static struct LightButtonFactory: public HierarhyWidgetFactory {
	
	LightButtonFactory(): HierarhyWidgetFactory("lightButton", &factory_fltk_checkButton) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::LightButton>(gui, *this);
	}
	
} factory_fltk_lightButton;


//----------========== fltk::RadioLightButton ==========----------//

static struct RadioLightButtonFactory: public HierarhyWidgetFactory {
	
	RadioLightButtonFactory(): HierarhyWidgetFactory("radioLightButton", &factory_fltk_lightButton) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::RadioLightButton>(gui, *this);
	}
	
} factory_fltk_radioLightButton;

//----------========== fltk::HighlightButton ==========----------//

static struct HighlightButtonFactory: public HierarhyWidgetFactory {
	
	HighlightButtonFactory(): HierarhyWidgetFactory("highlightButton", &factory_fltk_button) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::HighlightButton>(gui, *this);
	}
	
} factory_fltk_highlightButton;


//----------========== fltk::RepeatButton ==========----------//

static struct RepeatButtonFactory: public HierarhyWidgetFactory {
	
	RepeatButtonFactory(): HierarhyWidgetFactory("repeatButton", &factory_fltk_button) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::RepeatButton>(gui, *this);
	}
	
} factory_fltk_repeatButton;

//----------========== fltk::ReturnButton ==========----------//

static struct ReturnButtonFactory: public HierarhyWidgetFactory {
	
	ReturnButtonFactory(): HierarhyWidgetFactory("returnButton", &factory_fltk_button) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::ReturnButton>(gui, *this);
	}
	
} factory_fltk_returnButton;

//----------========== fltk::ToggleButton ==========----------//

static struct ToggleButtonFactory: public HierarhyWidgetFactory {
	
	ToggleButtonFactory(): HierarhyWidgetFactory("toggleButton", &factory_fltk_button) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::ToggleButton>(gui, *this);
	}
	
} factory_fltk_toggleButton;

//----------========== fltk::ClockOutput ==========----------//

static struct ClockOutputFactory: public HierarhyWidgetFactory {
	
	ClockOutputFactory(): HierarhyWidgetFactory("clockOutput", &factory_fltk_widget) {
		getWidgetPropertySetters()["clockOutput.value"] = getWidgetPropertySetters()["value"] = cast_caller<fltk::ClockOutput, time_t, &fltk::ClockOutput::value>;
		//TODO value (int, int, int)
		//TODO type (enum)
	}

	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::ClockOutput>(gui, *this);
	}

} factory_fltk_clockOutput;

//----------========== fltk::Clock ==========----------//

static struct ClockFactory: public HierarhyWidgetFactory {
	
	ClockFactory(): HierarhyWidgetFactory("clock", &factory_fltk_clockOutput) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::Clock>(gui, *this);
	}	
	
} factory_fltk_clock;

//----------========== fltk::Divider ==========----------//

static struct DividerFactory: public HierarhyWidgetFactory {
	
	DividerFactory(): HierarhyWidgetFactory("divider", &factory_fltk_widget) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator0<fltk::Divider>(gui, *this);
	}
	
} factory_fltk_divider;

//----------========== fltk::Input ==========----------//

static struct InputFactory: public HierarhyWidgetFactory {
		
	InputFactory(): HierarhyWidgetFactory("input", &factory_fltk_widget) {
		//TODO all properties
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::Input>(gui, *this);
	}
	
} factory_fltk_input;

//----------========== fltk::NumericInput ==========----------//

static struct NumericInputFactory: public HierarhyWidgetFactory {
	
	NumericInputFactory(): HierarhyWidgetFactory("numericInput", &factory_fltk_input) {
		//TODO all properties
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::NumericInput>(gui, *this);
	}
	
} factory_fltk_numericInput;

//----------========== fltk::FloatInput ==========----------//

static struct FloatInputFactory: public HierarhyWidgetFactory {
	
	FloatInputFactory(): HierarhyWidgetFactory("floatInput", &factory_fltk_numericInput) {
		//TODO all properties
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::FloatInput>(gui, *this);
	}
	
} factory_fltk_floatInput;

//----------========== fltk::IntInput ==========----------//

static struct IntInputFactory: public HierarhyWidgetFactory {
	
	IntInputFactory(): HierarhyWidgetFactory("intInput", &factory_fltk_floatInput) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::IntInput>(gui, *this);
	}
	
} factory_fltk_intInput;

//----------========== fltk::Output ==========----------//

static struct OutputFactory: public HierarhyWidgetFactory {
	
	OutputFactory(): HierarhyWidgetFactory("output", &factory_fltk_input) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::Output>(gui, *this);
	}
	
} factory_fltk_output;

//----------========== fltk::MultiLineOutput ==========----------//

static struct MultiLineOutputFactory: public HierarhyWidgetFactory {
	
	MultiLineOutputFactory(): HierarhyWidgetFactory("multiLineOutput", &factory_fltk_output) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::MultiLineOutput>(gui, *this);
	}
	
} factory_fltk_multiLineOutput;

//----------========== fltk::WordwrapOutput ==========----------//

static struct WordwrapOutputFactory: public HierarhyWidgetFactory {
	
	WordwrapOutputFactory(): HierarhyWidgetFactory("wordwrapOutput", &factory_fltk_output) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::WordwrapOutput>(gui, *this);
	}
	
} factory_fltk_wordwrapOutput;

//----------========== fltk::InvisibleBox ==========----------//

static struct InvisibleBoxFactory: public HierarhyWidgetFactory {
	
	InvisibleBoxFactory(): HierarhyWidgetFactory("invisibleBox", &factory_fltk_widget) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::InvisibleBox>(gui, *this);
	}
	
} factory_fltk_invisibleBox;

//----------========== fltk::Item ==========----------//

static struct ItemFactory: public HierarhyWidgetFactory {
	
	ItemFactory(): HierarhyWidgetFactory("item", &factory_fltk_widget) {
		//TODO type
		//TODO set_style
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator0<fltk::Item>(gui, *this);
	}
	
} factory_fltk_item;

//----------========== TODO fltk::RadioItem ?? ==========----------//

//----------========== fltk::Valuator ==========----------//

static struct ValuatorFactory: public HierarhyWidgetFactory {
	
	ValuatorFactory(): HierarhyWidgetFactory(0, &factory_fltk_widget) {
		//TODO property set
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		//schould never called
		return 0;
	}
	
} factory_fltk_valuator;

//----------========== fltk::Adjuster ==========----------//

static struct AdjusterFactory: public HierarhyWidgetFactory {
	
	AdjusterFactory(): HierarhyWidgetFactory("adjuster", &factory_fltk_valuator) {
		getWidgetPropertySetters()["adjuster.soft"] = getWidgetPropertySetters()["soft"] = cast_caller<fltk::Adjuster, int, &fltk::Adjuster::soft>;
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::Adjuster>(gui, *this);
	}
	
} factory_fltk_adjuster;	//Depreciated!

//----------========== fltk::Dial ==========----------//

static struct DialFactory: public HierarhyWidgetFactory {
	
	DialFactory(): HierarhyWidgetFactory("dial", &factory_fltk_valuator) {
		getWidgetPropertySetters()["dial.angle1"] = getWidgetPropertySetters()["angle1"] = cast_caller<fltk::Dial, short, &fltk::Dial::angle1>;
		getWidgetPropertySetters()["dial.angle2"] = getWidgetPropertySetters()["angle1"] = cast_caller<fltk::Dial, short, &fltk::Dial::angle2>;
		//TODO ? angels
		//TODO type
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::Dial>(gui, *this);
	}
	
} factory_fltk_dial;

//----------========== fltk::FillDial ==========----------//

static struct FillDialFactory: public HierarhyWidgetFactory {
	
	FillDialFactory(): HierarhyWidgetFactory("fillDial", &factory_fltk_dial) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::FillDial>(gui, *this);
	}
	
} factory_fltk_fillDial;

//----------========== fltk::LineDial  ==========----------//

static struct LineDialFactory: public HierarhyWidgetFactory {
	
	LineDialFactory(): HierarhyWidgetFactory("lineDial", &factory_fltk_dial) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::LineDial>(gui, *this);
	}
	
} factory_fltk_lineDial;

//----------========== fltk::Slider ==========----------//

static struct SliderFactory: public HierarhyWidgetFactory {
	
	SliderFactory(): HierarhyWidgetFactory("slider", &factory_fltk_valuator) {
		//TODO ? type
		getWidgetPropertySetters()["slider.slider_size"] = getWidgetPropertySetters()["slider_size"] = cast_caller<fltk::Slider, int, &fltk::Slider::slider_size>;
		getWidgetPropertySetters()["slider.tick_size"] = getWidgetPropertySetters()["tick_size"] = cast_caller<fltk::Slider, int, &fltk::Slider::tick_size>;
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::Slider>(gui, *this);
	}
	
} factory_fltk_slider;

//----------========== fltk::FillSlider ==========----------//

static struct FillSliderFactory: public HierarhyWidgetFactory {
	
	FillSliderFactory(): HierarhyWidgetFactory("fillSlider", &factory_fltk_slider) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::FillSlider>(gui, *this);
	}
	
} factory_fltk_fillSlider;

//----------========== fltk::Scrollbar ==========----------//

static struct ScrollbarFactory: public HierarhyWidgetFactory {
	
	ScrollbarFactory(): HierarhyWidgetFactory("scrollbar", &factory_fltk_slider) {
		getWidgetPropertySetters()["scrollbar.pagesize"] = getWidgetPropertySetters()["scrollbar"] = cast_caller<fltk::Scrollbar, int, &fltk::Scrollbar::pagesize>;		
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::Scrollbar>(gui, *this);
	}
	
} factory_fltk_scrollbar;

//----------========== fltk::ValueSlider ==========----------//

static struct ValueSliderFactory: public HierarhyWidgetFactory {
	
	ValueSliderFactory(): HierarhyWidgetFactory("valueSlider", &factory_fltk_slider) {
		//TODO input (do new creator and factory and use factory_fltk_floatInput)
		//"input.*"
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::ValueSlider>(gui, *this);
	}
	
} factory_fltk_valueSlider;

//----------========== fltk::ThumbWheel ==========----------//

static struct ThumbWheelFactory: public HierarhyWidgetFactory {
	
	ThumbWheelFactory(): HierarhyWidgetFactory("thumbWheel", &factory_fltk_valuator) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::ThumbWheel>(gui, *this);
	}
	
} factory_fltk_thumbWheel;

//----------========== fltk::ValueInput ==========----------//

static struct ValueInputFactory: public HierarhyWidgetFactory {
	
	ValueInputFactory(): HierarhyWidgetFactory("valueInput", &factory_fltk_valuator) {
		//TODO input (do new creator and factory and use factory_fltk_floatInput)
		//"input.*"
	}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::ValueInput>(gui, *this);
	}
	
} factory_fltk_valueInput;

//----------========== fltk::ValueOutput ==========----------//

static struct ValueOutputFactory: public HierarhyWidgetFactory {
	
	ValueOutputFactory(): HierarhyWidgetFactory("valueOutput", &factory_fltk_valuator) {}
	
	virtual WidgetCreator* getCreator(GUI& gui) {
		return new HierarhyWidgetCreator<fltk::ValueOutput>(gui, *this);
	}
	
} factory_fltk_valueOutput;

//----------========== fltk::Group ==========----------//

class GroupWidgetCreatorBase: public WidgetCreator {
	
	protected:
	
	HierarhyWidgetFactory& factory;
	
	fltk::Group* g;
	
	public:
	
	const char* resizable_name;

	virtual fltk::Group* new_widget() {
		return new fltk::Group(0, 0, 0, 0);
	}
	
	GroupWidgetCreatorBase(GUI& gui, HierarhyWidgetFactory& factory): WidgetCreator(gui), factory(factory), resizable_name(0) {}
	
	virtual fltk::Widget* create_begin(const char** attr) {
		g = new_widget();
		factory.setProperties(g, attr, *this);
		g->begin();
		return g;
	}
	
	virtual void create_end() {
		fltk::Group::current(fltk::Group::current()->parent());
		if (resizable_name)	//TODO error check, resizable_name exist?
			g->resizable(gui()[resizable_name]);
	};
	
	virtual ~GroupWidgetCreatorBase() {
		delete[] resizable_name;
	}
	
};

template <typename fltkGroup>
struct GroupWidgetCreator: public GroupWidgetCreatorBase {
	
	GroupWidgetCreator(GUI& gui, HierarhyWidgetFactory& factory): GroupWidgetCreatorBase(gui, factory) {}
	
	virtual fltk::Group* new_widget() {
		return new fltkGroup(0, 0, 0, 0);
	}
};

template <typename fltkGroup>
struct GroupWidgetCreator0: public GroupWidgetCreatorBase {
	
	GroupWidgetCreator0(GUI& gui, HierarhyWidgetFactory& factory): GroupWidgetCreatorBase(gui, factory) {}
	
	virtual fltk::Group* new_widget() {
		return new fltkGroup();
	}
};

void resizable(fltk::Widget* obj, const char* value, WidgetCreator& creator) {
	GroupWidgetCreatorBase& c = dynamic_cast<GroupWidgetCreatorBase&>(creator);
	delete[] c.resizable_name;
	c.resizable_name = utils::strcopy(value);
}

static struct FactoryGroup: public HierarhyWidgetFactory {
	
	FactoryGroup(): HierarhyWidgetFactory("group", &factory_fltk_widget) {
		getWidgetPropertySetters()["group.resizable"] = getWidgetPropertySetters()["resizable"] = resizable;
	}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreatorBase(gui, *this); };
	
} factory_fltk_group;

//----------========== fltk::Menu ==========----------//

static struct FactoryMenu: public HierarhyWidgetFactory {
	
	FactoryMenu(): HierarhyWidgetFactory("menu", &factory_fltk_group) {
		//TODO all properties
	}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator<fltk::Menu>(gui, *this); };
	
} factory_fltk_menu;

//----------========== fltk::Browser ==========----------//

static struct FactoryBrowser: public HierarhyWidgetFactory {
	
	FactoryBrowser(): HierarhyWidgetFactory("browser", &factory_fltk_menu) {
		//TODO all properties
	}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator<fltk::Browser>(gui, *this); };
	
} factory_fltk_browser;

//----------========== fltk::MultiBrowser ==========----------//

static struct FactoryMultiBrowser: public HierarhyWidgetFactory {
	
	FactoryMultiBrowser(): HierarhyWidgetFactory("multiBrowser", &factory_fltk_browser) {}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator<fltk::MultiBrowser>(gui, *this); };
	
} factory_fltk_multiBrowser;

//----------========== fltk::Choice ==========----------//

static struct FactoryChoice: public HierarhyWidgetFactory {
	
	FactoryChoice(): HierarhyWidgetFactory("choice", &factory_fltk_menu) {}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator<fltk::Choice>(gui, *this); };
	
} factory_fltk_choice;

//----------========== fltk::CycleButton ==========----------//

static struct FactoryCycleButton: public HierarhyWidgetFactory {
	
	FactoryCycleButton(): HierarhyWidgetFactory("cycleButton", &factory_fltk_menu) {}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator<fltk::CycleButton>(gui, *this); };
	
} factory_fltk_cycleButton;

//----------========== fltk::InputBrowser ?? ==========----------//

//----------========== fltk::ItemGroup ==========----------//

static struct FactoryItemGroup: public HierarhyWidgetFactory {
	
	FactoryItemGroup(): HierarhyWidgetFactory("itemGroup", &factory_fltk_menu) {
		//TODO all properties
	}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator0<fltk::ItemGroup>(gui, *this); };
	
} factory_fltk_itemGroup;

//----------========== fltk::MenuBar ==========----------//

static struct FactoryMenuBar: public HierarhyWidgetFactory {
	
	FactoryMenuBar(): HierarhyWidgetFactory("menuBar", &factory_fltk_menu) {
		//TODO all properties
	}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator<fltk::MenuBar>(gui, *this); };
	
} factory_fltk_menuBar;

//----------========== fltk::PopupMenu ==========----------//

static struct FactoryPopupMenu: public HierarhyWidgetFactory {
	
	FactoryPopupMenu(): HierarhyWidgetFactory("popupMenu", &factory_fltk_menu) {
		//TODO type
	}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator<fltk::PopupMenu>(gui, *this); };
	
} factory_fltk_popupMenu;

//----------========== fltk::PacketGroup ==========----------//

static struct FactoryPackedGroup: public HierarhyWidgetFactory {
	
	FactoryPackedGroup(): HierarhyWidgetFactory("packedGroup", &factory_fltk_group) {
		//TODO type
		getWidgetPropertySetters()["packedGroup.spacing"] = getWidgetPropertySetters()["spacing"] = cast_caller<fltk::PackedGroup, int, &fltk::PackedGroup::spacing>;
	}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator<fltk::PackedGroup>(gui, *this); };
	
} factory_fltk_packedGroup;

//----------========== fltk::ScrollGroup ==========----------//

static struct FactoryScrollGroup: public HierarhyWidgetFactory {
	
	FactoryScrollGroup(): HierarhyWidgetFactory("scrollGroup", &factory_fltk_group) {
		//TODO all properties
	}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator<fltk::ScrollGroup>(gui, *this); };
	
} factory_fltk_scrollGroup;

//----------========== fltk::TabGroup ==========----------//

static struct FactoryTabGroup: public HierarhyWidgetFactory {
	
	FactoryTabGroup(): HierarhyWidgetFactory("tabGroup", &factory_fltk_group) {
		//TODO all properties
	}
	
	WidgetCreator* getCreator(GUI& gui) { return new GroupWidgetCreator<fltk::TabGroup>(gui, *this); };
	
} factory_fltk_tabGroup;

//----------========== fltk::Window ==========----------//

struct WindowCreator: public GroupWidgetCreatorBase {
	
	WindowCreator(GUI& gui, HierarhyWidgetFactory& factory): GroupWidgetCreatorBase(gui, factory) {}
	
	virtual fltk::Group* new_widget() {
		return new fltk::Window(0, 0);
	}
};

struct FactoryWindow: public HierarhyWidgetFactory {
	
	FactoryWindow(): HierarhyWidgetFactory("window", &factory_fltk_group) {};
	
	WidgetCreator* getCreator(GUI& gui) { return new WindowCreator(gui, *this); };
	
} factory_fltk_window;

//----------========== fltk::MenuWindow ?? ==========----------//

//----------========== fltk::Tooltip ?? ==========----------//

//----------========== fltk::ShapedWindow ==========----------//

static struct FactoryShapedWindow: public HierarhyWidgetFactory {
	
	FactoryShapedWindow(): HierarhyWidgetFactory("shapedWindow", &factory_fltk_window) {};
	
	WidgetCreator* getCreator(GUI& gui) { return new WindowCreator(gui, *this); };
	
} factory_fltk_shapedWindow;



} //namespace xfltk
