#include "Error.h"

#include <sstream>

namespace xfltk {

// Error

std::ostream& operator<<(std::ostream& out_stream, const Error& error) {
	return out_stream << error.what();
}

Errors::size_type Errors::size() const {
	return errors.size();
}

// Errors

bool Errors::empty() const {
	return errors.empty();
}

const Error& Errors::operator[](Errors::size_type n) const {
	return *errors[n];
}

void Errors::append(Error* error) {
	errors.push_back(error);
}

void Errors::clear() {
	for (error_vec::iterator i = errors.begin(); i != errors.end(); ++i)
		delete *i;
	errors.clear();
}

std::ostream& operator<<(std::ostream& out_stream, const Errors& errors) {
	for (Errors::size_type i = 0; i < errors.size(); ++i)
		out_stream << errors[i].line_nr() << ": " << errors[i] << std::endl;
	return out_stream;
}

// GeneralDynamicError

GeneralDynamicError::GeneralDynamicError(const char* text, int line_nr, ParserAction parser_action)
: Error(line_nr, parser_action), _dynamic_text(utils::strcopy(text))
{}

GeneralDynamicError::GeneralDynamicError(const GeneralDynamicError& to_copy) 
: Error(to_copy._line_nr, to_copy._parser_action), _dynamic_text(utils::strcopy(to_copy._dynamic_text))
{}

// InvalidTagError

const char* InvalidTagError::make_text(const char* tag_name) {
	std::stringstream s;
 	s << "\"" << tag_name << "\" is not valid widget name";
 	return utils::strcopy(s.str().c_str());
}

InvalidTagError::InvalidTagError(const char* tag_name, int line_nr, ParserAction parser_action)
: GeneralDynamicError(make_text(tag_name), line_nr, parser_action) {}

};
